// ---------------------------------------------------- //
//                      WinIo v3.0                      //
//          Direct Hardware Access Under Windows        //
//           Copyright 1998-2010 Yariv Kaplan           //
//               http://www.internals.com               //
// ---------------------------------------------------- //


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.IO;
using System.Timers;
using System.Threading;



namespace DumpPort
{
    public unsafe partial class Form1 : Form
    {

        
        [DllImport("kernel32.dll")]
        private extern static IntPtr LoadLibrary(String DllName);

        [DllImport("kernel32.dll")]
        private extern static IntPtr GetProcAddress(IntPtr hModule, String ProcName);

        [DllImport("kernel32")]
        private extern static bool FreeLibrary(IntPtr hModule);

        [UnmanagedFunctionPointer(CallingConvention.StdCall)]
        private delegate bool InitializeWinIoType();

        [UnmanagedFunctionPointer(CallingConvention.StdCall)]
        private delegate bool GetPortValType(UInt16 PortAddr, UInt32* pPortVal, UInt16 Size);

        [UnmanagedFunctionPointer(CallingConvention.StdCall)]
        private delegate bool SetPortValType(UInt16 PortAddr, UInt32 PortVal, UInt16 Size);

        // new add
        [UnmanagedFunctionPointer(CallingConvention.StdCall)]
        private delegate bool GetPortVal1Type(UInt16 PortAddr, UInt32* pPortValGPI, UInt16 Size);

        [UnmanagedFunctionPointer(CallingConvention.StdCall)]
        private delegate bool SetPortVal1Type(UInt16 PortAddr, UInt32 PortValGPI, UInt16 Size);
        // new end

        [UnmanagedFunctionPointer(CallingConvention.StdCall)]
        private delegate bool ShutdownWinIoType();

        IntPtr hMod;
      //  int data; 

        public Form1()
        {
            InitializeComponent();

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // Check if this is a 32 bit or 64 bit system
            if (IntPtr.Size == 4)
            {
                hMod = LoadLibrary("WinIo32.dll");

            }
            else if (IntPtr.Size == 8)
            {
                hMod = LoadLibrary("WinIo64.dll");
            }

            if (hMod == IntPtr.Zero)
            {
                MessageBox.Show("Can't find WinIo dll.\nMake sure the WinIo library files are located in the same directory as your executable file.", "DumpPort", MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.Close();
            }

            IntPtr pFunc = GetProcAddress(hMod, "InitializeWinIo");

            if (pFunc != IntPtr.Zero)
            {
                InitializeWinIoType InitializeWinIo = (InitializeWinIoType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(InitializeWinIoType));
                bool Result = InitializeWinIo();

                if (!Result)
                {
                    MessageBox.Show("Error returned from InitializeWinIo.\nMake sure you are running with administrative privileges and that the WinIo library files are located in the same directory as your executable file.", "DumpPort", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    FreeLibrary(hMod);
                    this.Close();
                }
            }

            btnGetValue_Click(this, null);
        }

        private void btnQuit_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "ShutdownWinIo");

            if (pFunc != IntPtr.Zero)
            {
                ShutdownWinIoType ShutdownWinIo = (ShutdownWinIoType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(ShutdownWinIoType));

                ShutdownWinIo();
                FreeLibrary(hMod);
            }
          
            this.Close();
        }

        private void btnGetValue_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "GetPortVal");

            if (pFunc != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;

                PortAddr = UInt16.Parse(txtPortAddr.Text, System.Globalization.NumberStyles.HexNumber);

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(GetPortValType));
                
                
                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);

                if (Result)
                {
                    txtValue.Text = PortVal.ToString("X");
                }
                else
                {
                    MessageBox.Show("Error returned from GetPortVal", "DumpPort", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void btnSetValue_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");

            if (pFunc != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;

                PortAddr = UInt16.Parse(txtPortAddr.Text, System.Globalization.NumberStyles.HexNumber);
                PortVal = UInt32.Parse(txtValue.Text, System.Globalization.NumberStyles.HexNumber);

                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));

                // Call WinIo to set value
                bool Result = SetPortVal(PortAddr, PortVal, 1 );

                if (!Result)
                {
                    MessageBox.Show("Error returned from SetPortVal", "DumpPort", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void txtPortAddr_TextChanged(object sender, EventArgs e)
        {

        }

        private void label4_Click(object sender, EventArgs e)
        {

        }

        private void label3_Click(object sender, EventArgs e)
        {

        }
        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {

        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void button4_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));
               
                SetPortVal(0xA35, 0xA2, 1);  // Set Read GPIO 5X Address
              
            }


            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 DolVal;
                PortAddr = 0xA36;

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                DolVal = PortVal & 0x0F;  // Set bit4~7 to "0" and keep others to original value 

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0xA35, 0xA1, 1);  // Set Write GPIO 5X Address
                    SetPortVal(0xA36, DolVal, 1);  // Set Write GPIO 5X Address
                }

            }
        }

        

        private IntPtr GetProcAddress(IntPtr hMod, string p, string p_3)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void txtValue_TextChanged(object sender, EventArgs e)
        {

        }

       
        private void button5_Click(object sender, EventArgs e)
        {

        }

        private void GETGPI_Value_TextChanged(object sender, EventArgs e)
        {

        }

        private void label5_Click(object sender, EventArgs e)
        {

        }

        private void label2_Click(object sender, EventArgs e)
        {

        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void button5_Click_1(object sender, EventArgs e)
      
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {

                SetPortVal1Type SetPortVal = (SetPortVal1Type)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortVal1Type));
     
                SetPortVal(0x4E, 0x87, 1);
                SetPortVal(0x4E, 0x87, 1);
                SetPortVal(0x4E, 0x07, 1);
                SetPortVal(0x4F, 0x06, 1);
                SetPortVal(0x4E, 0xA2, 1);  
            }
            
            
            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 DiVal;

                PortAddr = 0x4f;

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                DiVal = PortVal & 0x0F;

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0x4E, 0xAA, 1);  // exit PNP mode

                }
  
                if (Result)
                {
                    txtValue.Text = PortVal.ToString("X");

                   
                    if (DiVal == 0x01)
                    {
                        MessageBox.Show("DI1 is High | DI2,DI3 and DI4 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }
                    else if (DiVal == 0x02)
                    {
                        MessageBox.Show("DI2 is High | DI1,DI3 and DI4 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }

                    else if (DiVal == 0x03)
                    {
                        MessageBox.Show("DI1 and DI2 | DI3 and DI4 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }

                    else if (DiVal == 0x04)
                    {
                        MessageBox.Show("DI3 is High | DI1, DI2 and DI4 is Low", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }

                    else if (DiVal == 0x05)
                    {
                        MessageBox.Show("DI1 and DI3 | DI2 and DI4 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }
                    else if (DiVal == 0x06)
                    {
                        MessageBox.Show("DI2 and DI3 | DI1 and DI4 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }

                    else if (DiVal == 0x07)
                    {
                        MessageBox.Show("DI1, DI2 and DI3 is High | DI4 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }

                    else if (DiVal == 0x08)
                    {
                        MessageBox.Show("DI4 is High | DI1,DI2 and DI3 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }

                    else if (DiVal == 0x09)
                    {
                        MessageBox.Show("DI1 and DI4 is High | DI2 and DI3 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }

                    else if (DiVal == 0x0A)
                    {
                        MessageBox.Show("DI2 and DI4 is High  | DI1 and DI3 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }

                    else if (DiVal == 0x0B)
                    {
                        MessageBox.Show("DI1, DI2 and DI4 is High | DI3 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }
                    else if (DiVal == 0x0C)
                    {
                        MessageBox.Show("DI3 and DI4 is High | DI1 and DI2 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }

                    else if (DiVal == 0x0D)
                    {
                        MessageBox.Show("DI1, DI3 and DI4 is High | DI2 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }                    
                    else if (DiVal == 0x0E)
                    {
                        MessageBox.Show("DI1, DI2, DI3 is HIGH | DI4 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                    }
                    
                    else if (DiVal == 0x0F)
                    {
                        MessageBox.Show("DI1, DI2, DI3 and DI4 is HIGH ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                        radioButton4.Checked = true;
                    }
                    else if (DiVal == 0x00)
                    {
                        MessageBox.Show("DI1, DI2, DI3 and DI4 is Low ", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.None);
                        radioButton3.Checked = true;
                    }

                    else 
                    {
                        MessageBox.Show("Test Fail", "VBOX-3600 DIO Test", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        radioButton5.Checked = true;
                    }
                }
                else
                {
                    MessageBox.Show("Error returned from GetPortVal", "GPIO Port", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void button2_Click_1(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));
                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x07, 1);  // Select Logic 7 for GPIO
                SetPortVal(0x4F, 0x06, 1);  //
                SetPortVal(0x4E, 0xF2, 1);  // Set Read GPIO 0X Address
               
            }


            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 DolVal;
                PortAddr = 0x4f;

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                DolVal = PortVal & 0xFE;  // Set bit0 1111 1110 to "0" and keep others to original value 

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0x4E, 0xF1, 1);  // Set Write GPIO 0X Address
                    SetPortVal(0x4F, DolVal, 1);  // Set Write GPIO 0X Address
                    SetPortVal(0x4E, 0xAA, 1);  // exit PNP mode

                }

            }
        }

        private void button3_Click_1(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));
                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x07, 1);  // Select Logic 7 for GPIO
                SetPortVal(0x4F, 0x06, 1);  //
                SetPortVal(0x4E, 0xF2, 1);  // Set Read GPIO 0X Address
            }


            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 DolVal;
                PortAddr = 0x4f;

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                DolVal = PortVal | 0x01;  // Set bit0 to 0000 0001 "1" and keep others to original value 

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0x4E, 0xF1, 1);  // Set Write GPIO 0X Address
                    SetPortVal(0x4F, DolVal, 1);  // Set Write GPIO 0X Address
                    SetPortVal(0x4E, 0xAA, 1);  // exit PNP mode

                }

            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {

                SetPortVal1Type SetPortVal = (SetPortVal1Type)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortVal1Type));

                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x07, 1);  // Select Logic 7 for GPIO
                SetPortVal(0x4F, 0x06, 1);  //
                SetPortVal(0x4E, 0xF2, 1);  // Set GPI 0X Address
            }


            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 IgnVal;
                PortAddr = 0x4f;

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                IgnVal = PortVal & 0x08;   // bit3

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0x4E, 0xAA, 1);  // exit PNP mode

                }

                if (Result)
                {
                    txtValue.Text = PortVal.ToString("X");

                    if (IgnVal == 0x08)
                    {
                        MessageBox.Show("Ignition is On (High)", "VBOX-3600 Test Tools V1", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        radioButton1.Checked = true;
                    }
                    else if (IgnVal == 0x00)
                    {
                        MessageBox.Show("Ignition is Off (Low)", "VBOX-3600 Test Tools V1", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        radioButton2.Checked = true;
                    }

                }
                else
                {
                    MessageBox.Show("Error returned from GetPortVal", "DumpPort", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {

        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {

        }

        private void label5_Click_1(object sender, EventArgs e)
        {

        }

       
        private void button7_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {

                SetPortVal1Type SetPortVal = (SetPortVal1Type)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortVal1Type));
 
                SetPortVal(0xA05, 0x74, 1);  // Set Temp2 (74h) to Hardware Monitor Address Port (225h)           
            }


            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                PortAddr = 0xA06; // Hardware Monitor Data Port(226h)
                // PortAddr = 0x4f;
                int j = 0;
                int result1 = 0;
                string temp2;

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);

                
//------------------ 16i10i---------------------------------------

                temp2 = PortVal.ToString();

                for (int i = 0; i < temp2.Length; i++)
                {
                    result1 = result1 * 16;
                    j = temp2[i] - 48;

                    if (j < 10)
                    {
                        result1 = result1 + j;
                    }

                    else
                    {
                        result1 = result1 + j - 39;
                    }

                }

//------------------ 16i10i---------------------------------------        
      

                if (Result)
                {
                 
                    textBox2.Text = temp2;
                }
                else
                {
                    MessageBox.Show("Error returned from GetPortVal", "DumpPort", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }

            IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
            if (pFunc2 != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                SetPortVal(0x4E, 0xAA, 1);  // exit PNP mode

            }
        }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {
            
        }

        private void button8_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));
                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x07, 1);  // Select Logic 7 for GPIO
                SetPortVal(0x4F, 0x06, 1);  //
                SetPortVal(0x4E, 0xF2, 1);  // Set Read GPIO 0X Address
               
            }


            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 UMTS2_Val;
                PortAddr = 0x4f;


                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                UMTS2_Val = PortVal | 0x02;  // Set bit1 to "1" and keep others to original value 

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0x4E, 0xF1, 1);  // Set Write GPIO 0X Address
                    SetPortVal(0x4F, UMTS2_Val, 1);  // Set Read GPIO 0X Address
                    Thread.Sleep(2000); //Delay 2 Sec (1000 is 1 Sec)
                    UMTS2_Val = PortVal & 0xFD ;  // Set bit1 to "0" and keep others to original value 
                    SetPortVal(0x4F, UMTS2_Val, 1);  // Set Read GPIO 0X Address
                    SetPortVal(0x4E, 0xAA, 1);  // exit PNP mode

                }

            }

        }

        

        private void button13_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));
                
                SetPortVal(0xA16, 0x01, 1);  // Set watchdog timer value to 10
                SetPortVal(0xA15, 0x3A, 1);  // Set watchdog timer unit is sec and enable watchdog

            }

        }

        private void button12_Click_1(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));
                
                SetPortVal(0xA16, 0x0A, 1);  // Set watchdog timer value to 10
                SetPortVal(0xA15, 0x32, 1);  // Set watchdog timer unit is sec and enable watchdog
           
            }
        }

        private void button11_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                UInt32 REG_Value;
                UInt32 FID_MSB;
                UInt16 Ctrl = 0x48;
               
                
                SetPortVal1Type SetPortVal = (SetPortVal1Type)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortVal1Type));

                SetPortVal(0xF040, 0xFF, 1);        // Clear SMBUS Status
                Thread.Sleep(10);                   //Delay 10 ms (1000 is 1 Sec) 
                SetPortVal(0xF044, 0xA5, 1);        // EEPROM Address A4 -Write / A5 -Read
                Thread.Sleep(10);
                SetPortVal(0xF043, 0x13, 1);        // EEPROM Reg 13h Address for Firmware Version
                Thread.Sleep(10);
                SetPortVal(0xF042, Ctrl, 1);        // Run SMBUS Command
                Thread.Sleep(10);


                IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

                if (pFunc1 != IntPtr.Zero)
                {


                    GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));

                    // Call WinIo to get value
                    bool Result = GetPortVal(0xF045, &REG_Value, 1);
                    FID_MSB = REG_Value;
                                      
                    if (Result)
                    {
                        textBox1.Text = REG_Value.ToString("X");

                        if (FID_MSB != 0xFF || FID_MSB != 0x00)
                        {
                            MessageBox.Show("Firmware OK ", "VBOX-3600 Firmware Version Check", MessageBoxButtons.OK, MessageBoxIcon.None);
                        }
                        
                        else
                        {
                            MessageBox.Show("Firmware Fail", "VBOX-3600 Firmware Version Check", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Error returned from GetPortVal", "VBOX-3600 Firmware Version Check", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                }
            }
        }

        private void textBox1_TextChanged_1(object sender, EventArgs e)
        {

        }

        private void button2_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));
                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x87, 1);  // Enter Super IO
                SetPortVal(0x4E, 0x07, 1);  // Select Logic 7 for GPIO
                SetPortVal(0x4F, 0x06, 1);  //
                SetPortVal(0x4E, 0xF2, 1);  // Set Read GPIO 0X Address

            }


            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 UMTS1_Val;
                PortAddr = 0x4f;


                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                UMTS1_Val = PortVal | 0x01 ;  // Set bit0 to "1" and keep others to original value 

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0x4E, 0xF1, 1);  // Set Write GPIO 0X Address
                    SetPortVal(0x4F, UMTS1_Val, 1);  // Set Read GPIO 0X Address
                    Thread.Sleep(2000); //Delay 2 Sec (1000 is 1 Sec)
                    UMTS1_Val = PortVal & 0xFE;  // Set bit0 to "0" and keep others to original value 
                    SetPortVal(0x4F, UMTS1_Val, 1);  // Set Read GPIO 0X Address
                    SetPortVal(0x4E, 0xAA, 1);  // exit PNP mode

                }

            }
        }

        private void radioButton4_CheckedChanged(object sender, EventArgs e)
        {

        }

        private void radioButton3_CheckedChanged(object sender, EventArgs e)
        {

        }

        private void button3_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                UInt32 REG_Value;
                UInt16 Ctrl = 0x48;
                
                REG_Value = UInt32.Parse(textBox3.Text, System.Globalization.NumberStyles.HexNumber);

                //  PortAddr = UInt16.Parse(textBox4.Text, System.Globalization.NumberStyles.HexNumber);

                SetPortVal1Type SetPortVal = (SetPortVal1Type)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortVal1Type));

                SetPortVal(0xF040, 0xFF, 1);        // Clear SMBUS Status
                Thread.Sleep(10);                   //Delay 10 ms (1000 is 1 Sec) 
                SetPortVal(0xF044, 0xA4, 1);        // EEPROM Address A4 -Write / A5 -Read
                Thread.Sleep(10);
                SetPortVal(0xF043, 0x20, 1);        // EEPROM Reg 20h Address 
                Thread.Sleep(10);
                SetPortVal(0xF042, Ctrl, 1);        // Run SMBUS Command
                SetPortVal(0xF045, 0xD1, 1);        // Select D1 for EEPROM
                Thread.Sleep(10);

                SetPortVal(0xF040, 0xFF, 1);        // Clear SMBUS Status
                Thread.Sleep(10);                   //Delay 10 ms (1000 is 1 Sec) 
                SetPortVal(0xF044, 0xA4, 1);        // EEPROM Address A4 -Write / A5 -Read
                Thread.Sleep(10);
                SetPortVal(0xF043, 0x31, 1);        // EEPROM Reg 31 Address Set value for delay time 
                Thread.Sleep(10);
                SetPortVal(0xF042, Ctrl, 1);        // Run SMBUS Command
                SetPortVal(0xF045, REG_Value, 1);   // Delay Value
                Thread.Sleep(10);

            }

            else
            {
                MessageBox.Show("Error returned from GetPortVal", "VBOX-3600 Firmware Version Check", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
                
            
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {

        }

        private void button9_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));
                
                SetPortVal(0xA35, 0xA2, 1);  // Set GPIO 5X Address
               
            }

            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 DohVal;
                PortAddr = 0xA36;

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                DohVal = PortVal | 0xF0;  // Set bit4~7 to "1" and keep others to original value 

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0xA35, 0xA1, 1);  // Set Write GPIO 5X Address
                    SetPortVal(0xA36, DohVal, 1);  // Set Write GPIO 5X Address
                }

            }

        }

        private void button6_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                UInt32 REG_Value;
                UInt32 FID_MSB;
                UInt16 Ctrl = 0x48;
                
                SetPortVal1Type SetPortVal = (SetPortVal1Type)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortVal1Type));

                SetPortVal(0xF040, 0xFF, 1);        // Clear SMBUS Status
                Thread.Sleep(10);                   //Delay 10 ms (1000 is 1 Sec) 
                SetPortVal(0xF044, 0xA5, 1);        // EEPROM Address A4 -Write / A5 -Read
                Thread.Sleep(10);
                SetPortVal(0xF043, 0x31, 1);        // Read EEPROM Reg 31h Address for Delay Time
                Thread.Sleep(10);
                SetPortVal(0xF042, Ctrl, 1);        // Run SMBUS Command
                Thread.Sleep(10);


                IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

                if (pFunc1 != IntPtr.Zero)
                {


                    GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));

                    // Call WinIo to get value
                    bool Result = GetPortVal(0xF045, &REG_Value, 1);
                    FID_MSB = REG_Value;

                    if (Result)
                    {
                        textBox3.Text = REG_Value.ToString("X");
                    }
                    else
                    {
                        MessageBox.Show("Error returned from GetPortVal", "VBOX-3600 Firmware Version Check", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                }
            }
        }

        private void label5_Click_2(object sender, EventArgs e)
        {

        }

        private void button14_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));

                SetPortVal(0xA35, 0xA2, 1);  // Set Read GPIO 5X Address

            }


            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 DolVal;
                PortAddr = 0xA36;

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                DolVal = PortVal & 0xEF;  // Set bit4 to "0" and keep others to original value 

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0xA35, 0xD1, 1);  // Set Write GPIO 2X Address
                    SetPortVal(0xA36, DolVal, 1);  // Set Write GPIO 2X Address
                }

            }
        }

        private void button10_Click(object sender, EventArgs e)
        {
            IntPtr pFunc = GetProcAddress(hMod, "SetPortVal");
            if (pFunc != IntPtr.Zero)
            {
                SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc, typeof(SetPortValType));

                SetPortVal(0xA35, 0xA2, 1);  // Set GPIO 5X Address

            }

            IntPtr pFunc1 = GetProcAddress(hMod, "GetPortVal");

            if (pFunc1 != IntPtr.Zero)
            {
                UInt16 PortAddr;
                UInt32 PortVal;
                UInt32 DohVal;
                PortAddr = 0xA36;

                GetPortValType GetPortVal = (GetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc1, typeof(GetPortValType));


                // Call WinIo to get value
                bool Result = GetPortVal(PortAddr, &PortVal, 1);
                DohVal = PortVal | 0x10;  // Set bit4 to "1" and keep others to original value 

                IntPtr pFunc2 = GetProcAddress(hMod, "SetPortVal");
                if (pFunc2 != IntPtr.Zero)
                {
                    SetPortValType SetPortVal = (SetPortValType)Marshal.GetDelegateForFunctionPointer(pFunc2, typeof(SetPortValType));
                    SetPortVal(0xA35, 0xD1, 1);  // Set Write GPIO 2X Address
                    SetPortVal(0xA36, DohVal, 1);  // Set Write GPIO 2X Address
                }

            }
        }

    }
}


